const Footer = () => {
  return (
    <footer className="bg-foreground py-12">
      <div className="container mx-auto px-4 md:px-6">
        <div className="grid grid-cols-1 md:grid-cols-4 gap-8">
          <div>
            <h3 className="font-heading text-lg font-bold text-background mb-4">
              ডিজি<span className="text-primary">মার্কেট</span>
            </h3>
            <p className="text-background/60 text-sm leading-relaxed">
              বাংলাদেশের সেরা ডিজিটাল প্রোডাক্ট মার্কেটপ্লেস। ক্রিয়েটরদের জন্য তৈরি।
            </p>
          </div>

          {[
            {
              title: "প্রোডাক্ট",
              links: ["ই-বুক", "টেমপ্লেট", "সফটওয়্যার", "কোর্স"],
            },
            {
              title: "কোম্পানি",
              links: ["আমাদের সম্পর্কে", "ব্লগ", "ক্যারিয়ার", "যোগাযোগ"],
            },
            {
              title: "সাপোর্ট",
              links: ["হেল্প সেন্টার", "প্রাইভেসি পলিসি", "শর্তাবলী", "রিফান্ড"],
            },
          ].map((section) => (
            <div key={section.title}>
              <h4 className="font-heading font-semibold text-background text-sm mb-4">{section.title}</h4>
              <ul className="space-y-2">
                {section.links.map((link) => (
                  <li key={link}>
                    <a href="#" className="text-background/50 text-sm hover:text-background transition-colors">
                      {link}
                    </a>
                  </li>
                ))}
              </ul>
            </div>
          ))}
        </div>

        <div className="border-t border-background/10 mt-10 pt-6 text-center">
          <p className="text-background/40 text-sm">© ২০২৫ ডিজিমার্কেট। সর্বস্বত্ব সংরক্ষিত।</p>
        </div>
      </div>
    </footer>
  );
};

export default Footer;
