import { ArrowRight, Sparkles } from "lucide-react";
import { Button } from "@/components/ui/button";
import heroBg from "@/assets/hero-bg.jpg";

const HeroSection = () => {
  return (
    <section className="relative min-h-[90vh] flex items-center overflow-hidden pt-16">
      <div className="absolute inset-0">
        <img src={heroBg} alt="Digital products" className="w-full h-full object-cover opacity-20" />
        <div className="absolute inset-0 bg-gradient-to-b from-background via-background/90 to-background" />
      </div>

      <div className="container mx-auto px-4 md:px-6 relative z-10">
        <div className="max-w-3xl mx-auto text-center">
          <div className="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-primary/10 text-primary text-sm font-medium mb-8 animate-fade-up">
            <Sparkles className="h-4 w-4" />
            বাংলাদেশের সেরা ডিজিটাল মার্কেটপ্লেস
          </div>

          <h1 className="font-heading text-4xl md:text-6xl lg:text-7xl font-bold text-foreground leading-tight mb-6 animate-fade-up" style={{ animationDelay: "0.1s" }}>
            আপনার ডিজিটাল
            <br />
            <span className="text-gradient-primary">প্রোডাক্ট বিক্রি</span> করুন
          </h1>

          <p className="text-lg md:text-xl text-muted-foreground max-w-xl mx-auto mb-10 animate-fade-up" style={{ animationDelay: "0.2s" }}>
            ই-বুক, টেমপ্লেট, কোর্স, সফটওয়্যার — যেকোনো ডিজিটাল প্রোডাক্ট সহজেই বিক্রি করুন এবং আয় করুন।
          </p>

          <div className="flex flex-col sm:flex-row items-center justify-center gap-4 animate-fade-up" style={{ animationDelay: "0.3s" }}>
            <Button size="lg" className="bg-gradient-hero text-primary-foreground hover:opacity-90 transition-opacity px-8 h-12 text-base font-semibold">
              এখনই শুরু করুন
              <ArrowRight className="ml-2 h-4 w-4" />
            </Button>
            <Button variant="outline" size="lg" className="h-12 text-base">
              প্রোডাক্ট দেখুন
            </Button>
          </div>

          <div className="mt-16 flex items-center justify-center gap-8 md:gap-12 text-center animate-fade-up" style={{ animationDelay: "0.4s" }}>
            {[
              { num: "৫০০+", label: "প্রোডাক্ট" },
              { num: "১০K+", label: "গ্রাহক" },
              { num: "২০০+", label: "ক্রিয়েটর" },
            ].map((stat) => (
              <div key={stat.label}>
                <div className="text-2xl md:text-3xl font-heading font-bold text-foreground">{stat.num}</div>
                <div className="text-sm text-muted-foreground mt-1">{stat.label}</div>
              </div>
            ))}
          </div>
        </div>
      </div>
    </section>
  );
};

export default HeroSection;
