import { motion } from "framer-motion";
import ShopProductCard from "./ShopProductCard";
import type { Product } from "./productsData";

interface ProductSectionProps {
  title: string;
  id: string;
  products: Product[];
}

const ProductSection = ({ title, id, products }: ProductSectionProps) => {
  return (
    <section id={id} className="py-8 md:py-10">
      <div className="container mx-auto px-4">
        <motion.div
          initial={{ opacity: 0, x: -20 }}
          whileInView={{ opacity: 1, x: 0 }}
          viewport={{ once: true }}
          transition={{ duration: 0.4 }}
          className="flex items-center gap-3 mb-6"
        >
          <div className="h-8 w-1 rounded-full bg-primary" />
          <h2 className="font-heading text-xl md:text-2xl font-bold text-foreground">{title}</h2>
          <div className="hidden sm:block flex-1 h-px bg-border ml-2" />
        </motion.div>
        <div className="grid grid-cols-2 sm:grid-cols-3 lg:grid-cols-4 xl:grid-cols-5 gap-2.5 sm:gap-4">
          {products.map((product, index) => (
            <ShopProductCard key={product.id} product={product} index={index} />
          ))}
        </div>
      </div>
    </section>
  );
};

export default ProductSection;
