import { User, LogOut } from "lucide-react";
import { useSiteSettings } from "@/hooks/useSiteSettings";
import { useAuth } from "@/contexts/AuthContext";
import { useNavigate } from "react-router-dom";

const TopBar = () => {
  const { settings } = useSiteSettings();
  const { user, signOut } = useAuth();
  const navigate = useNavigate();

  return (
    <div className="topbar text-xs py-2 hidden md:block">
      <div className="container mx-auto px-4 flex items-center justify-between">
        <div className="flex items-center gap-4">
          <span>📞 {settings.phone}</span>
          <span>📧 {settings.email}</span>
        </div>
        <div className="flex items-center gap-4">
          {user ? (
            <button onClick={async () => { await signOut(); navigate("/"); }} className="flex items-center gap-1 hover:text-primary-foreground transition-colors">
              <LogOut className="h-3.5 w-3.5" />
              Logout
            </button>
          ) : (
            <button onClick={() => navigate("/auth")} className="flex items-center gap-1 hover:text-primary-foreground transition-colors">
              <User className="h-3.5 w-3.5" />
              Login / Register
            </button>
          )}
        </div>
      </div>
    </div>
  );
};

export default TopBar;
