export interface DBCategory {
  id: string;
  name: string;
  sort_order: number;
  is_active: boolean;
}

export interface DBProduct {
  id: string;
  name: string;
  image_url: string | null;
  price: string;
  original_price: string | null;
  reseller_price: string | null;
  reseller_prices: Record<string, string> | null;
  category: string;
  description: string | null;
  features: string[] | null;
  duration_options: string[] | null;
  badges: string[] | null;
  created_at: string;
}

export interface DBOrder {
  id: string;
  customer_name: string;
  customer_phone: string | null;
  product_name: string;
  amount: string;
  status: string;
  created_at: string;
  payment_method?: string;
  payment_status?: string;
  transaction_id?: string;
  is_trashed?: boolean;
  user_id?: string | null;
}

export interface DBBanner {
  id: string;
  title: string;
  subtitle: string | null;
  description: string | null;
  cta_text: string | null;
  cta_link: string | null;
  secondary_cta_text: string | null;
  secondary_cta_link: string | null;
  image_url: string | null;
  is_active: boolean;
}
