import { useState, useEffect } from "react";
import { supabase } from "@/integrations/supabase/client";

export const useSiteLogo = () => {
  const [logoUrl, setLogoUrl] = useState<string | null>(null);

  useEffect(() => {
    const fetchLogo = async () => {
      const { data } = await supabase
        .from("site_settings")
        .select("value")
        .eq("key", "logo_url")
        .maybeSingle();
      if (data?.value) setLogoUrl(data.value);
    };
    fetchLogo();
  }, []);

  return logoUrl;
};
