
CREATE TABLE public.banners (
  id uuid PRIMARY KEY DEFAULT gen_random_uuid(),
  title text NOT NULL DEFAULT 'Premium Digital Products at Best Prices',
  subtitle text DEFAULT '#1 Digital Marketplace in BD',
  description text DEFAULT 'সফটওয়্যার, VPN, AI টুলস, গিফট কার্ড — সবকিছু সেরা দামে।',
  cta_text text DEFAULT 'Shop Now',
  cta_link text DEFAULT '#products',
  secondary_cta_text text DEFAULT 'Best Selling',
  secondary_cta_link text DEFAULT '#best-selling',
  image_url text,
  is_active boolean NOT NULL DEFAULT true,
  created_at timestamp with time zone NOT NULL DEFAULT now(),
  updated_at timestamp with time zone NOT NULL DEFAULT now()
);

ALTER TABLE public.banners ENABLE ROW LEVEL SECURITY;

CREATE POLICY "Anyone can view active banners"
  ON public.banners FOR SELECT
  USING (true);

CREATE POLICY "Admins can insert banners"
  ON public.banners FOR INSERT
  WITH CHECK (has_role(auth.uid(), 'admin'::app_role));

CREATE POLICY "Admins can update banners"
  ON public.banners FOR UPDATE
  USING (has_role(auth.uid(), 'admin'::app_role));

CREATE POLICY "Admins can delete banners"
  ON public.banners FOR DELETE
  USING (has_role(auth.uid(), 'admin'::app_role));

-- Insert default banner
INSERT INTO public.banners (title, subtitle, description, cta_text, cta_link, secondary_cta_text, secondary_cta_link, is_active)
VALUES (
  'Premium Digital Products at Best Prices',
  '#1 Digital Marketplace in BD',
  'সফটওয়্যার, VPN, AI টুলস, গিফট কার্ড — সবকিছু সেরা দামে। ইনস্ট্যান্ট ডেলিভারি, ২৪/৭ সাপোর্ট।',
  'Shop Now',
  '#products',
  'Best Selling',
  '#best-selling',
  true
);
