
-- Drop the constraint first since column was partially created
ALTER TABLE public.products DROP CONSTRAINT IF EXISTS products_slug_key;
ALTER TABLE public.products DROP COLUMN IF EXISTS slug;

-- Re-add slug column
ALTER TABLE public.products ADD COLUMN slug text;

-- Generate slugs with row_number to handle duplicates
WITH slugs AS (
  SELECT id, 
    LOWER(REGEXP_REPLACE(REGEXP_REPLACE(name, '[^a-zA-Z0-9\s-]', '', 'g'), '\s+', '-', 'g')) as base_slug,
    ROW_NUMBER() OVER (PARTITION BY LOWER(REGEXP_REPLACE(REGEXP_REPLACE(name, '[^a-zA-Z0-9\s-]', '', 'g'), '\s+', '-', 'g')) ORDER BY created_at) as rn
  FROM public.products
)
UPDATE public.products p
SET slug = CASE WHEN s.rn = 1 THEN s.base_slug ELSE s.base_slug || '-' || s.rn END
FROM slugs s
WHERE p.id = s.id;

ALTER TABLE public.products ALTER COLUMN slug SET NOT NULL;
ALTER TABLE public.products ADD CONSTRAINT products_slug_key UNIQUE (slug);
