
CREATE TABLE public.partners (
  id uuid NOT NULL DEFAULT gen_random_uuid() PRIMARY KEY,
  name text NOT NULL,
  logo_url text,
  sort_order integer NOT NULL DEFAULT 0,
  is_active boolean NOT NULL DEFAULT true,
  created_at timestamp with time zone NOT NULL DEFAULT now()
);

ALTER TABLE public.partners ENABLE ROW LEVEL SECURITY;

CREATE POLICY "Anyone can view active partners" ON public.partners FOR SELECT USING (true);
CREATE POLICY "Admins can insert partners" ON public.partners FOR INSERT WITH CHECK (has_role(auth.uid(), 'admin'::app_role));
CREATE POLICY "Admins can update partners" ON public.partners FOR UPDATE USING (has_role(auth.uid(), 'admin'::app_role));
CREATE POLICY "Admins can delete partners" ON public.partners FOR DELETE USING (has_role(auth.uid(), 'admin'::app_role));

INSERT INTO storage.buckets (id, name, public) VALUES ('partners', 'partners', true) ON CONFLICT (id) DO NOTHING;

CREATE POLICY "Anyone can view partner logos" ON storage.objects FOR SELECT USING (bucket_id = 'partners');
CREATE POLICY "Admins can upload partner logos" ON storage.objects FOR INSERT WITH CHECK (bucket_id = 'partners');
CREATE POLICY "Admins can update partner logos" ON storage.objects FOR UPDATE USING (bucket_id = 'partners');
CREATE POLICY "Admins can delete partner logos" ON storage.objects FOR DELETE USING (bucket_id = 'partners');
