
CREATE TABLE public.product_reviews (
  id UUID NOT NULL DEFAULT gen_random_uuid() PRIMARY KEY,
  product_id UUID NOT NULL REFERENCES public.products(id) ON DELETE CASCADE,
  user_id UUID NOT NULL,
  user_name TEXT NOT NULL DEFAULT 'Anonymous',
  rating INTEGER NOT NULL CHECK (rating >= 1 AND rating <= 5),
  comment TEXT,
  is_approved BOOLEAN NOT NULL DEFAULT false,
  created_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now()
);

ALTER TABLE public.product_reviews ENABLE ROW LEVEL SECURITY;

-- Anyone can view approved reviews
CREATE POLICY "Anyone can view approved reviews" ON public.product_reviews
  FOR SELECT USING (is_approved = true);

-- Admins can view all reviews
CREATE POLICY "Admins can view all reviews" ON public.product_reviews
  FOR SELECT USING (has_role(auth.uid(), 'admin'::app_role));

-- Authenticated users can insert reviews
CREATE POLICY "Authenticated users can insert reviews" ON public.product_reviews
  FOR INSERT WITH CHECK (auth.uid() = user_id);

-- Admins can update reviews (approve/reject)
CREATE POLICY "Admins can update reviews" ON public.product_reviews
  FOR UPDATE USING (has_role(auth.uid(), 'admin'::app_role));

-- Admins can delete reviews
CREATE POLICY "Admins can delete reviews" ON public.product_reviews
  FOR DELETE USING (has_role(auth.uid(), 'admin'::app_role));
