
CREATE TABLE public.product_faqs (
  id UUID NOT NULL DEFAULT gen_random_uuid() PRIMARY KEY,
  product_id UUID NOT NULL REFERENCES public.products(id) ON DELETE CASCADE,
  question TEXT NOT NULL,
  answer TEXT NOT NULL,
  sort_order INTEGER NOT NULL DEFAULT 0,
  created_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now()
);

ALTER TABLE public.product_faqs ENABLE ROW LEVEL SECURITY;

-- Anyone can view FAQs
CREATE POLICY "Anyone can view product FAQs" ON public.product_faqs
  FOR SELECT USING (true);

-- Admins can manage FAQs
CREATE POLICY "Admins can insert FAQs" ON public.product_faqs
  FOR INSERT WITH CHECK (has_role(auth.uid(), 'admin'::app_role));

CREATE POLICY "Admins can update FAQs" ON public.product_faqs
  FOR UPDATE USING (has_role(auth.uid(), 'admin'::app_role));

CREATE POLICY "Admins can delete FAQs" ON public.product_faqs
  FOR DELETE USING (has_role(auth.uid(), 'admin'::app_role));
