
-- Drop the old public SELECT policy that exposes everything
DROP POLICY IF EXISTS "Anyone can view site settings" ON public.site_settings;

-- Create a new public SELECT policy that only allows viewing non-sensitive keys
CREATE POLICY "Public can view non-sensitive settings"
  ON public.site_settings FOR SELECT
  USING (
    key NOT IN (
      'developer_password',
      'ucbot_api_token',
      'ucbot_api_url',
      'ucbot_enabled',
      'tzsmmpay_api_key',
      'payment_gateway_url',
      'awaj_api_token',
      'awaj_voice_name',
      'awaj_sender_number',
      'sms_api_key',
      'smtp_host',
      'smtp_user',
      'smtp_password',
      'smtp_port',
      'smtp_from_email',
      'smtp_from_name',
      'whatsapp_api_token',
      'whatsapp_instance_id',
      'facebook_pixel_id',
      'facebook_pixel_token',
      'facebook_capi_enabled'
    )
    OR has_role(auth.uid(), 'admin'::app_role)
  );
