
-- Drop and recreate with even more sensitive keys blocked
DROP POLICY IF EXISTS "Public can view non-sensitive settings" ON public.site_settings;

CREATE POLICY "Public can view non-sensitive settings"
  ON public.site_settings FOR SELECT
  USING (
    key NOT LIKE '%password%'
    AND key NOT LIKE '%token%'
    AND key NOT LIKE '%api_key%'
    AND key NOT LIKE '%api_secret%'
    AND key NOT LIKE '%secret%'
    AND key NOT LIKE '%smtp%'
    AND key NOT LIKE '%instance_id%'
    AND key NOT LIKE '%pixel_id%'
    AND key NOT LIKE '%pixel_token%'
    AND key NOT LIKE '%capi_enabled%'
    AND key NOT IN ('ucbot_api_url', 'ucbot_enabled', 'payment_gateway_url')
    OR has_role(auth.uid(), 'admin'::app_role)
  );

-- Ensure user_roles is locked down - only admins can read
DROP POLICY IF EXISTS "Admins can manage roles" ON public.user_roles;
CREATE POLICY "Admins can manage all roles"
  ON public.user_roles FOR ALL
  USING (has_role(auth.uid(), 'admin'::app_role));

-- Users can only read their own role
CREATE POLICY "Users can read own role"
  ON public.user_roles FOR SELECT
  USING (user_id = auth.uid());
