
CREATE TABLE public.incomplete_orders (
  id uuid NOT NULL DEFAULT gen_random_uuid() PRIMARY KEY,
  session_id text NOT NULL,
  name text DEFAULT '',
  email text DEFAULT '',
  phone text DEFAULT '',
  cart_items jsonb DEFAULT '[]'::jsonb,
  cart_total numeric DEFAULT 0,
  created_at timestamp with time zone NOT NULL DEFAULT now(),
  updated_at timestamp with time zone NOT NULL DEFAULT now(),
  is_converted boolean NOT NULL DEFAULT false
);

-- RLS
ALTER TABLE public.incomplete_orders ENABLE ROW LEVEL SECURITY;

-- Anyone can insert/update (anonymous checkout users)
CREATE POLICY "Anyone can insert incomplete orders" ON public.incomplete_orders FOR INSERT WITH CHECK (true);
CREATE POLICY "Anyone can update own incomplete order" ON public.incomplete_orders FOR UPDATE USING (true);
CREATE POLICY "Admins can view incomplete orders" ON public.incomplete_orders FOR SELECT USING (has_role(auth.uid(), 'admin'::app_role));
CREATE POLICY "Admins can delete incomplete orders" ON public.incomplete_orders FOR DELETE USING (has_role(auth.uid(), 'admin'::app_role));

-- Enable realtime
ALTER PUBLICATION supabase_realtime ADD TABLE public.incomplete_orders;
